/* sccsid[] = "@(#) $Id: //bas/46D/src/include/crfcsimp.h#3 $ SAP" */   
//
// SAP RFC C++ Class library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved.
                        
////////////////////////////////////////////////////////////////////////////////
//  File crfcsimp.h
//
//  Declarations for class CRfcSimpleParam  
////////////////////////////////////////////////////////////////////////////////

#ifndef CRFCSIMP__H
#define CRFCSIMP__H

#include "crfcglob.h"
#include "crfcimex.h"

class CRfcPersistStream;

#ifdef _WIN32

#define CRFCSIMP_CONSTRUCTOR_PARAMNAME \
            _T("CRfcSimpleParam::CRfcSimpleParam(CSTR paramName...) called")
#define CRFCSIMP_CONSTRUCTOR_SOURCEPARAM \
            _T("CRfcSimpleParam::CRfcSimpleParam (const CRfcSimpleParam& sourceParam) called")
#define CRFCSIMP_DESTRUCTOR \
            _T("CRfcSimpleParam::~CRfcSimpleParam() called")
#define CRFCSIMP_ISSIMPLEPARAM \
            _T("CRfcSimpleParam::IsSimpleParam () const called")
#define CRFCSIMP_OPERATOR_EQUAL \
            _T("CRfcSimpleParam::operator=(const CRfcSimpleParam& sourceParam) called")
#define CRFCSIMP_SETATTRIBUTES \
            _T("CRfcSimpleParam::SetAttributes(unsigned nType...) called")
#define CRFCSIMP_CLEAR \
            _T("CRfcSimpleParam::Clear() called")
#define CRFCSIMP_FILLPARAMSTRUCT \
            _T("CRfcSimpleParam::FillParamStruct(RFC_PARAMETER *pParamStruct) const called")
#define CRFCSIMP_CONVERTDATA \
            _T("CRfcSimpleParam::ConvertData (void) called")
#define CRFCSIMP_READ \
            _T("CRfcSimpleParam::Read (void) called")
#define CRFCSIMP_MEMORY_FAILURE \
            _T("Memory Allocation Failure")

#else

#define CRFCSIMP_CONSTRUCTOR_PARAMNAME \
            "CRfcSimpleParam::CRfcSimpleParam(CSTR paramName...) called"
#define CRFCSIMP_CONSTRUCTOR_SOURCEPARAM \
            "CRfcSimpleParam::CRfcSimpleParam (const CRfcSimpleParam& sourceParam) called"
#define CRFCSIMP_DESTRUCTOR \
            "CRfcSimpleParam::~CRfcSimpleParam() called"
#define CRFCSIMP_ISSIMPLEPARAM \
            "CRfcSimpleParam::IsSimpleParam () const called"
#define CRFCSIMP_OPERATOR_EQUAL \
            "CRfcSimpleParam::operator=(const CRfcSimpleParam& sourceParam) called"
#define CRFCSIMP_SETATTRIBUTES \
            "CRfcSimpleParam::SetAttributes(unsigned nType...) called"
#define CRFCSIMP_CLEAR \
            "CRfcSimpleParam::Clear() called"
#define CRFCSIMP_FILLPARAMSTRUCT \
            "CRfcSimpleParam::FillParamStruct(RFC_PARAMETER *pParamStruct) const called"
#define CRFCSIMP_CONVERTDATA \
            "CRfcSimpleParam::ConvertData (void) called"
#define CRFCSIMP_READ \
            "CRfcSimpleParam::Read (void) called"
#define CRFCSIMP_MEMORY_FAILURE \
            "Memory Allocation Failure"

#endif

class CRfcFunction;

////////////////////////////////////////////////////////////////////////////////
// CRfcSimpleParam class declaration 

class CRfcSimpleParam : public CRfcImpExpParam
{
    friend class CRfcFunction;

public:
// constructor & destructor
    // Both constructors throw const char* for memory allocation failures.
    CRfcSimpleParam (CSTR paramName=NULL, //Parameter name
                     unsigned nType=TYPC, //Parameter type (RFC data type) 
                     int nLength=0,       //Parameter value length in bytes
                     int nDecimals=0,     //number of decimals in value
					 BOOL bAutoCreate=FALSE);  //  If the simple parameter object auto-created or not
    CRfcSimpleParam (const CRfcSimpleParam& sourceParam);

    virtual ~CRfcSimpleParam(void);

// operations

    // Throws const char* for memory allocation failures.
    CRfcSimpleParam&    operator=  (const CRfcSimpleParam& sourceParam );

    // friend ostream&	    operator<< (ostream&, CRfcSimpleParam&); 

    // Function for identifying parameter class, 
    // inherited from CRfcImpExpParam
    virtual BOOL    IsSimpleParam () const { return TRUE; }

	virtual BOOL IsAutoCreated(void) const {return m_bAutoCreate;}
	
    // Returns parameter type 
    unsigned        GetType (void) const { return m_nType; }
    // Returns number of decimal places in parameter
    unsigned        GetDecimals(void) const { return m_nDecimals; }

    // Set parameter attributes. Only allowed when the
    // parameter object was created via the default constructor
    // and its attributes have not been set before.
    // Throws const char* for memory allocation failures.
    void            SetAttributes(unsigned nType,
                                  int nLength=0,
                                  int nDecimals=0);
    
    // Reset the parameter to an appropriate initial value.
    virtual void    Clear (void); 

    // Returns a reference to CRfcData object.
    // This function can be used to assign and retrieve values
    // from the parameter through the support of CRfcData.
    // User should not be concerned with or make any use of the 
    // intermediate CRfcData object.
    // i.e. x.Value() = 5 or
    //     y = x.Value() ;
    CRfcData&       Value (void) { assert( m_nLength > 0 ); m_bPassImportToR3 = TRUE; return m_RfcData;  }   
    const CRfcData& Value (void) const { assert( m_nLength > 0 ); return m_RfcData; }//For reading value from 
                                        //a const simpleParam obj    

#if defined(SAPonNT)
    BOOL Write(CRfcPersistStream& ps, CSTR dir);
    BOOL Read(CRfcPersistStream& ps, CSTR funcname, CSTR dir, int nIndex);
#endif  // #if defined(SAPonNT)


protected:
    // Fill RFC_PARAMETER structure using class data
    virtual void    FillParamStruct    (RFC_PARAMETER *pParamStruct) const;

    // Do data conversion for values obtained from R/3
    virtual void    ConvertData (void);

//attributes
    unsigned        m_nType;              //Parameter RFC data type
    unsigned        m_nDecimals;          //number of decimal places in
                                          // parameter value

	BOOL			m_bAutoCreate;		//  Indicates if the parameter object
										//  is automatically created by the class
										//  library or not.

};

#include "crfcpers.h"

#endif          //CRFCSIMP__H


